/*
 *  XMail by Davide Libenzi ( Intranet and Internet mail server )
 *  Copyright (C) 1999,...,2002  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */


#ifndef _SYSTYPESWIN_H
#define _SYSTYPESWIN_H



#define SYS_OS_PORT             "Win32/" SYS_CPU_PORT

#define SYS_INFINITE_TIMEOUT    (4 * 1024 * 1024)
#define SYS_DEFAULT_MAXCOUNT    (INT_MAX - 1)

#define SYS_SLASH_CHAR          '\\'
#define SYS_SLASH_STR           "\\"
#define SYS_MAX_PATH            _MAX_PATH

#define SYS_LLU_FMT             "%I64u"
#define SYS_LLX_FMT             "%I64X"

#define SYS_INVALID_HANDLE      ((SYS_HANDLE) 0)
#define SYS_INVALID_SOCKET      ((SYS_SOCKET) INVALID_SOCKET)
#define SYS_INVALID_SEMAPHORE   ((SYS_SEMAPHORE) 0)
#define SYS_INVALID_MUTEX       ((SYS_MUTEX) 0)
#define SYS_INVALID_EVENT       ((SYS_EVENT) 0)
#define SYS_INVALID_THREAD      ((SYS_THREAD) 0)
#define SYS_INVALID_NET_ADDRESS ((NET_ADDRESS) INADDR_NONE)

#define SYS_THREAD_ONCE_INIT    0

#define SysSNPrintf             _snprintf

#define SYS_fd_set              fd_set
#define SYS_FD_ZERO             FD_ZERO
#define SYS_FD_CLR              FD_CLR
#define SYS_FD_SET              FD_SET
#define SYS_FD_ISSET            FD_ISSET

#define SYS_SPINLOCK_UNLOCKED   0




typedef char    SYS_INT8;
typedef unsigned char SYS_UINT8;
typedef short int SYS_INT16;
typedef unsigned short int SYS_UINT16;
typedef int     SYS_INT32;
typedef unsigned int SYS_UINT32;
typedef __int64 SYS_INT64;
typedef unsigned __int64 SYS_UINT64;
typedef unsigned __int64 SYS_LONGLONG;
typedef unsigned int SYS_PTRUINT;
typedef unsigned long SYS_HANDLE;
typedef int SYS_TLSKEY;
typedef LONG    SYS_THREAD_ONCE;
typedef SOCKET  SYS_SOCKET;
typedef int     socklen_t;
typedef HANDLE  SYS_SEMAPHORE;
typedef HANDLE  SYS_MUTEX;
typedef HANDLE  SYS_EVENT;
typedef LONG    SYS_SPINLOCK;
typedef unsigned long SYS_THREAD;
typedef unsigned long NET_ADDRESS;





struct SYS_INET_ADDR
{
    struct sockaddr_in Addr;
};

enum SysFileTypes
{
    ftNormal = 1,
    ftDirectory,
    ftLink,
    ftOther,

    ftMax
};

struct SYS_FILE_INFO
{
    int             iFileType;
    unsigned long   ulSize;
    time_t          tMod;
};




#endif
