/*
 *  MailSvr by Davide Libenzi ( Intranet and Internet mail server )
 *  Copyright (C) 1999  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davide_libenzi@mycio.com>
 *
 */


#ifndef _ERRORS_H
#define _ERRORS_H



///////////////////////////////////////////////////////////////////////////////
//  Remeber to update error strings i Errors.cpp
///////////////////////////////////////////////////////////////////////////////
#define ERR_SUCCESS                 0
#define ERR_SERVER_SHUTDOWN         (-1)
#define ERR_MEMORY                  (-2)
#define ERR_NETWORK                 (-3)
#define ERR_SOCKET_CREATE           (-4)
#define ERR_TIMEOUT                 (-5)
#define ERR_LOCKED                  (-6)
#define ERR_SOCKET_BIND             (-7)
#define ERR_CONF_PATH               (-8)
#define ERR_USERS_FILE_NOT_FOUND    (-9)
#define ERR_FILE_CREATE             (-10)
#define ERR_USER_NOT_FOUND          (-12)
#define ERR_USER_EXIST              (-13)
#define ERR_WRITE_USERS_FILE        (-14)
#define ERR_NO_USER_PRFILE          (-15)
#define ERR_FILE_DELETE             (-16)
#define ERR_DIR_CREATE              (-17)
#define ERR_DIR_DELETE              (-18)
#define ERR_FILE_OPEN               (-19)
#define ERR_INVALID_FILE            (-20)
#define ERR_FILE_WRITE              (-21)
#define ERR_MSG_NOT_IN_RANGE        (-22)
#define ERR_MSG_DELETED             (-23)
#define ERR_INVALID_PASSWORD        (-24)
#define ERR_ALIAS_FILE_NOT_FOUND    (-25)
#define ERR_ALIAS_EXIST             (-26)
#define ERR_WRITE_ALIAS_FILE        (-27)
#define ERR_ALIAS_NOT_FOUND         (-28)
#define ERR_SVR_PRFILE_NOT_LOCKED   (-29)
#define ERR_GET_PEER_INFO           (-30)
#define ERR_SMTP_PATH_PARSE_ERROR   (-31)
#define ERR_BAD_RETURN_PATH         (-32)
#define ERR_BAD_EMAIL_ADDR          (-33)
#define ERR_RELAY_NOT_ALLOWED       (-34)
#define ERR_BAD_FORWARD_PATH        (-35)
#define ERR_GET_SOCK_INFO           (-36)
#define ERR_GET_SOCK_HOST           (-37)
#define ERR_NO_DOMAIN               (-38)
#define ERR_USER_NOT_LOCAL          (-39)
#define ERR_BAD_SERVER_ADDR         (-40)
#define ERR_BAD_SERVER_RESPONSE     (-41)
#define ERR_INVALID_POP3_RESPONSE   (-42)
#define ERR_LINKS_FILE_NOT_FOUND    (-43)
#define ERR_LINK_EXIST              (-44)
#define ERR_WRITE_LINKS_FILE        (-45)
#define ERR_LINK_NOT_FOUND          (-46)
#define ERR_NO_SMTP_SPOOL_FILES     (-47)
#define ERR_SMTPGW_FILE_NOT_FOUND   (-48)
#define ERR_GATEWAY_ALREADY_EXIST   (-49)
#define ERR_GATEWAY_NOT_FOUND       (-50)
#define ERR_USER_NOT_MAILINGLIST    (-51)
#define ERR_NO_USER_MLTABLE_FILE    (-52)
#define ERR_MLUSER_ALREADY_EXIST    (-53)
#define ERR_MLUSER_NOT_FOUND        (-54)
#define ERR_SPOOL_FILE_NOT_FOUND    (-55)
#define ERR_INVALID_SPOOL_FILE      (-56)
#define ERR_SPOOL_FILE_NOT_READY    (-57)
#define ERR_SPOOL_FILE_EXPIRED      (-58)
#define ERR_SMTPRELAY_FILE_NOT_FOUND (-59)
#define ERR_DOMAINS_FILE_NOT_FOUND  (-60)
#define ERR_DOMAIN_NOT_HANDLED      (-61)
#define ERR_BAD_SMTP_RESPONSE       (-62)
#define ERR_CFG_VAR_NOT_FOUND       (-63)
#define ERR_BAD_DNS_RESPONSE        (-64)
#define ERR_SMTPGW_NOT_FOUND        (-65)
#define ERR_INCOMPLETE_CONFIG       (-67)
#define ERR_MAIL_ERROR_LOOP         (-68)
#define ERR_EXTALIAS_FILE_NOT_FOUND (-69)
#define ERR_EXTALIAS_EXIST          (-70)
#define ERR_WRITE_EXTALIAS_FILE     (-71)
#define ERR_EXTALIAS_NOT_FOUND      (-72)
#define ERR_NO_USER_DEFAULT_PRFILE  (-73)
#define ERR_FINGER_QUERY_FORMAT     (-74)
#define ERR_LOCKED_RESOURCE         (-76)
#define ERR_NO_PREDEFINED_MX        (-78)
#define ERR_NO_MORE_MXRECORDS       (-79)
#define ERR_INVALID_MESSAGE_FORMAT  (-80)
#define ERR_SMTP_BAD_MAIL_FROM      (-81)
#define ERR_SMTP_BAD_RCPT_TO        (-82)
#define ERR_SMTP_BAD_DATA           (-83)
#define ERR_INVALID_MXRECS_STRING   (-84)
#define ERR_SETSOCKOPT              (-85)
#define ERR_CREATEEVENT             (-86)
#define ERR_CREATESEMAPHORE         (-87)
#define ERR_CLOSEHANDLE             (-88)
#define ERR_RELEASESEMAPHORE        (-89)
#define ERR_BEGINTHREADEX           (-90)
#define ERR_CREATEFILEMAPPING       (-91)
#define ERR_MAPVIEWOFFILE           (-92)
#define ERR_UNMAPVIEWOFFILE         (-93)
#define ERR_SEMGET                  (-94)
#define ERR_SEMCTL                  (-95)
#define ERR_SEMOP                   (-96)
#define ERR_FORK                    (-97)
#define ERR_SHMGET                  (-98)
#define ERR_SHMCTL                  (-99)
#define ERR_SHMAT                   (-100)
#define ERR_SHMDT                   (-101)
#define ERR_OPENDIR                 (-102)
#define ERR_STAT                    (-103)
#define ERR_SMTP_BAD_CMD_SEQUENCE   (-104)
#define ERR_NO_ROOT_DOMAIN_VAR      (-105)
#define ERR_NS_NOT_FOUND            (-106)
#define ERR_NO_DEFINED_MXS_FOR_DOMAIN   (-107)
#define ERR_BAD_CTRL_COMMAND        (-108)
#define ERR_DOMAIN_ALREADY_HANDLED  (-109)
#define ERR_BAD_CTRL_LOGIN          (-110)
#define ERR_CTRL_ACCOUNTS_FILE_NOT_FOUND    (-111)
#define ERR_RBL_SPAMMER             (-112)
#define ERR_SPAMMER_IP              (-113)
#define ERR_TRUNCATED_DGRAM_DNS_RESPONSE    (-114)
#define ERR_NO_DGRAM_DNS_RESPONSE   (-115)
#define ERR_EMPTY_DNS_RESPONSE      (-116)
#define ERR_BAD_SMARTDNSHOST_SYNTAX (-117)
#define ERR_MAILBOX_SIZE            (-118)
#define ERR_DYNDNS_CONFIG           (-119)
#define ERR_INVALID_SHARED_BLOCK    (-120)
#define ERR_PROCESS_EXECUTE         (-121)
#define ERR_BAD_MAILPROC_CMD_SYNTAX (-122)
#define ERR_NO_MAILPROC_FILE        (-123)
#define ERR_DNS_RECURSION_NOT_AVAILABLE (-124)
#define ERR_POP3_EXTERNAL_LINK_DISABLED (-125)
#define ERR_RSS_SPAMMER             (-126)
#define ERR_BAD_DOMAIN_PROC_CMD_SYNTAX  (-128)
#define ERR_NOT_A_CUSTOM_DOMAIN     (-129)
#define ERR_NO_MORE_TOKENS          (-130)
#define ERR_SELECT                  (-131)
#define ERR_REGISTER_EVENT_SOURCE   (-132)
#define ERR_NOMORESEMS              (-133)
#define ERR_INVALID_SEMAPHORE       (-134)
#define ERR_SHMEM_ALREADY_EXIST     (-135)
#define ERR_SHMEM_NOT_EXIST         (-136)
#define ERR_SEM_ALREADY_EXIST       (-137)
#define ERR_SEM_NOT_EXIST           (-138)
#define ERR_SERVER_BUSY             (-139)
#define ERR_IP_NOT_ALLOWED          (-140)
#define ERR_FILE_EOF                (-141)
#define ERR_BAD_TAG_ADDRESS         (-142)
#define ERR_MAILFROM_UNKNOWN        (-143)
#define ERR_FILTERED_MESSAGE        (-144)
#define ERR_NO_DOMAIN_FILTER        (-145)
#define ERR_POP3_RETR_BROKEN        (-146)
#define ERR_CCLN_INVALID_RESPONSE   (-147)
#define ERR_CCLN_ERROR_RESPONSE     (-148)
#define ERR_INCOMPLETE_PROCESSING   (-149)
#define ERR_NO_EXTERNAL_AUTH_DEFINED    (-150)
#define ERR_EXTERNAL_AUTH_FAILURE   (-151)
#define ERR_MD5_AUTH_FAILED         (-152)
#define ERR_NO_SMTP_AUTH_CONFIG     (-153)
#define ERR_UNKNOWN_SMTP_AUTH       (-154)
#define ERR_BAD_SMTP_AUTH_CONFIG    (-155)
#define ERR_BAD_EXTRNPRG_EXITCODE   (-156)
#define ERR_BAD_SMTP_CMD_SYNTAX     (-157)
#define ERR_SMTP_AUTH_FAILED        (-158)
#define ERR_BAD_SMTP_EXTAUTH_RESPONSE_FILE  (-159)
#define ERR_SMTP_USE_FORBIDDEN      (-160)
#define ERR_SPAM_ADDRESS            (-161)
#define ERR_SOCK_NOMORE_DATA        (-162)
#define ERR_BAD_TAB_INDEX_FIELD     (-163)
#define ERR_FILE_READ               (-164)
#define ERR_BAD_INDEX_FILE          (-165)
#define ERR_INDEX_HASH_NOT_FOUND    (-166)
#define ERR_RECORD_NOT_FOUND        (-167)
#define ERR_HEAP_ALLOC              (-168)
#define ERR_HEAP_FREE               (-169)
#define ERR_RESOURCE_NOT_LOCKED     (-170)
#define ERR_LOCK_ENTRY_NOT_FOUND    (-171)
#define ERR_LINE_TOO_LONG           (-172)
#define ERR_MAIL_LOOP_DETECTED      (-173)
#define ERR_FILE_MOVE               (-174)
#define ERR_INVALID_MAILDIR_SUBPATH (-175)
#define ERR_SMTP_TOO_MANY_RECIPIENTS    (-176)
#define ERR_DNS_CACHE_FILE_FMT      (-177)
#define ERR_DNS_CACHE_FILE_EXPIRED  (-178)
#define ERR_MMAP                    (-179)
#define ERR_NOT_LOCKED              (-180)
#define ERR_SMTPFWD_FILE_NOT_FOUND  (-181)
#define ERR_SMTPFWD_NOT_FOUND       (-182)
#define ERR_USER_BREAK              (-183)
#define ERR_SET_THREAD_PRIORITY     (-184)
#define ERR_INVALID_QUEUE_PATH      (-185)
#define ERR_QUEUE_ARRAY_FULL        (-186)
#define ERR_QUEUE_ENTRY_NOT_FOUND   (-187)
#define ERR_NULL_SENDER             (-188)
#define ERR_RCPTTO_UNKNOWN          (-189)
#define ERR_LOADMODULE              (-190)
#define ERR_LOADMODULESYMBOL        (-191)









int             ErrGetErrorCode(void);
void            ErrSetErrorCode(int iError, char const * pszInfo = NULL);
const char     *ErrGetErrorString(int iError);
const char     *ErrGetErrorString(void);
char           *ErrGetErrorStringInfo(int iError);
int             ErrLogMessage(int iLogLevel, char const * pszFormat,...);
int             ErrFileVLogMessage(char const * pszFileName, char const * pszFormat,
                        va_list Args);
void            ErrCleanupErrorInfos(int iFreeInfos);





#endif
