/*
 *  SndMail by Davide Libenzi ( SMTP Internet mail delivery agent )
 *  Copyright (C) 2000, 2001  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */

#ifndef _SOCKIO_H
#define _SOCKIO_H


#if _MSC_VER >= 1000
#pragma once
#endif          // _MSC_VER >= 1000




#define SOCK_VERSION_REQUESTED          MAKEWORD(2, 0)





BOOL            SvrInitSockets(char *pszSockDesc, int (*pIdleProc) (void *) = NULL,
                        void *pIdleData = NULL);
void            SvrCleanupSockets(void);
void            SvrSetStepTimeout(DWORD dwTimeout);
void            SvrSetRTXBlockSize(int iRTXSize);
int             SvrSetBlocking(SOCKET sockfd, int on);
BOOL            SvrSetLocalCallback(int (*pLocalIdleProc) (void *), void *pLocalIdleData);
int             SvrConnectTimeout(SOCKET SockFD, const struct sockaddr * pSockName,
                        int iNameLen, int iTimeout);
SOCKET          SvrAcceptTimeout(SOCKET SockFD, struct sockaddr * pSockName, int *iNameLen,
                        int iTimeout);
int             SvrSend(SOCKET SockFD, BYTE * pBuffer, int iSize, int iFlags, int iTimeout);
int             SvrRecv(SOCKET SockFD, BYTE * pBuffer, int iSize, int iFlags, int iTimeout);
int             SvrSendTo(SOCKET SockFD, BYTE * pBuffer, int iSize, int iFlags,
                        const struct sockaddr FAR * lpTo, int iToLen);
int             SvrTryRecv(SOCKET SockFD, BYTE * pBuffer, int iSize, int iFlags, int iTimeout = -1);
int             SvrRecvFrom(SOCKET SockFD, BYTE * pBuffer, int iSize, int iFlags,
                        struct sockaddr FAR * lpFrom, LPINT lpFromlen);
SOCKET          SvrCreateSocket(int iAddressFamily, int iType, int iProtocol);
int             SvrCloseSocket(SOCKET SockFD, int iHardClose = 0);
SOCKET          SvrConnectServer(char *pszSvrNode, int iSvrPort, int iTimeout);
BOOL            SvrSendDWORD(SOCKET SockFD, DWORD dwData, int iTimeout);
BOOL            SvrRecvDWORD(SOCKET SockFD, DWORD * pdwData, int iTimeout);
BOOL            SvrSendWORD(SOCKET SockFD, WORD wData, int iTimeout);
BOOL            SvrRecvWORD(SOCKET SockFD, WORD * pwData, int iTimeout);
SOCKET          SvrGetChildSocket(SOCKET SockFD, int iStartPortNo, int iEndPortNo,
                        int iAcceptTimeout, int iSendTimeout);
SOCKET          SvrSwitchConnectServer(char *pszSvrNode, int iSvrPort, int iConnectTimeout,
                        int iRecvTimeout);



#endif
