/*
 *  SndMail by Davide Libenzi ( SMTP Internet mail delivery agent )
 *  Copyright (C) 2000, 2001  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */


#ifndef _SNDMAIL_H
#define _SNDMAIL_H




#define VERSION_STRING                  "SndMail 1.9 by Davide Libenzi <davidel@xmailserver.org>"


#define STD_SMTP_TIMEOUT                45

#define ERR_BAD_SMTP_RESPONSE           (-1)
#define ERR_BAD_SERVER_ADDR             (-2)
#define ERR_BAD_SERVER_RESPONSE         (-3)
#define ERR_FILE_CREATE                 (-4)
#define ERR_FILE_OPEN                   (-5)
#define ERR_INVALID_MSD_VERSION         (-6)
#define ERR_MSD_NO_BODYFILE             (-7)
#define ERR_MSD_NO_SUBJECT              (-8)
#define ERR_MSD_NO_FROM                 (-9)
#define ERR_MSD_NO_RCPT                 (-10)
#define ERR_NO_SOCK_SUPPORT             (-11)
#define ERR_UNKNOWN_SWITCH              (-12)
#define ERR_INVALID_ERROR_CODE          (-13)
#define ERR_NO_MORE_TOKENS              (-14)
#define ERR_MEMORY_ALLOCATION           (-15)
#define ERR_NO_AUTH_INFO                (-16)




#define STD_BOUNDARY_DELIMITER          "----=_NextPart_000_00BF_01BF610E.1038FD70"


#define SMF_HTML_BODY                   (1 << 0)






struct MailSendData
{
    unsigned int    uSize;
    char const     *pszBodyFile;
    char const     *pszSubject;
    char const     *pszFrom;
    char const     *pszFromExt;
    char           *const * ppszRcpt;
    char           *const * ppszCC;
    char           *const * ppszTags;
    char const     *pszReply;
    char const     *pszErrors;
    char const     *pszSender;
    char const     *pszBoundary;
    char           *const * ppszAttach;
    unsigned long   ulFlags;
    char const     *pszAuthType;
    char const     *pszUsername;
    char const     *pszPassword;
};





int WINAPI      USmtpLibOpen(void);
int WINAPI      USmtpLibClose(void);
int WINAPI      USmtpSendMail(char const * pszServer, int iPortNo, char const * pszDomain,
                        MailSendData const * pMSD);
int WINAPI      USmptGetErrorInfo(int iErrorCode, char *pszBuffer, int iBufferSize);
int WINAPI      USmtpArgsSendMail(int iArgCount, char *pszArgs[]);
int WINAPI      USmtpCmdLineSendMail(char const * pszCmdLine);





#endif
