/*
 *  SndMail by Davide Libenzi ( SMTP Internet mail delivery agent )
 *  Copyright (C) 2000, 2001  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */


#ifndef _BUFFSOCK_H
#define _BUFFSOCK_H


#define STD_SOCK_BUFFER_SIZE        4096

#define INVALID_BSOCK_HANDLE        ((BSOCK_HANDLE) 0)



typedef struct BSOCK_HANDLE_struct
{
}              *BSOCK_HANDLE;




BSOCK_HANDLE    BSckAttach(SOCKET SockFD, int iBufferSize = STD_SOCK_BUFFER_SIZE);
SOCKET          BSckDetach(BSOCK_HANDLE hBSock, int iCloseSocket = 0);
int             BSckGetChar(BSOCK_HANDLE hBSock, int iTimeout);
char           *BSckGetString(BSOCK_HANDLE hBSock, char *pszBuffer, int iBufferSize, int iTimeout);
int             BSckSendString(BSOCK_HANDLE hBSock, char *pszBuffer, int iTimeout);
SOCKET          BSckGetAttachedSocket(BSOCK_HANDLE hBSock);




#endif
