/*
 *  SndMail by Davide Libenzi ( SMTP Internet mail delivery agent )
 *  Copyright (C) 2000, 2001  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */


#include <winsock2.h>
#include <mswsock.h>
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <ctype.h>
#include <limits.h>
#include "sockio.h"
#include "BuffSock.h"





#define BSOCK_EOF                   INT_MIN

#define INext(i, n)                 ((((i) + 1) < (n)) ? ((i) + 1): 0)





struct BuffSocketData
{
    SOCKET          SockFD;
    int             iBufferSize;
    char           *pszBuffer;
    int             iBytesInBuffer;
    int             iReadIndex;
    int             iBufferIndex;
};





static int      BSckReadData(BuffSocketData * pBSD, int iTimeout);






BSOCK_HANDLE    BSckAttach(SOCKET SockFD, int iBufferSize)
{

    BuffSocketData *pBSD = (BuffSocketData *) malloc(sizeof(BuffSocketData));

    if (pBSD == NULL)
        return (INVALID_BSOCK_HANDLE);

    char           *pszBuffer = (char *) malloc(iBufferSize);

    if (pszBuffer == NULL)
    {
        free(pBSD);
        return (INVALID_BSOCK_HANDLE);
    }

    pBSD->SockFD = SockFD;
    pBSD->iBufferSize = iBufferSize;
    pBSD->pszBuffer = pszBuffer;
    pBSD->iBytesInBuffer = 0;
    pBSD->iReadIndex = 0;
    pBSD->iBufferIndex = 0;

    return ((BSOCK_HANDLE) pBSD);

}



SOCKET          BSckDetach(BSOCK_HANDLE hBSock, int iCloseSocket)
{

    BuffSocketData *pBSD = (BuffSocketData *) hBSock;
    SOCKET          SockFD = pBSD->SockFD;

    free(pBSD->pszBuffer);

    free(pBSD);

    if (iCloseSocket)
    {
        SvrCloseSocket(SockFD);
        return (INVALID_SOCKET);
    }

    return (SockFD);

}



static int      BSckReadData(BuffSocketData * pBSD, int iTimeout)
{

    int             iMaxRead = pBSD->iBufferSize - pBSD->iBytesInBuffer;
    char           *pszBuffer = (char *) malloc(iMaxRead + 1);

    if (pszBuffer == NULL)
        return (-1);

    int             iReadedBytes = SvrTryRecv(pBSD->SockFD, (unsigned char *) pszBuffer, iMaxRead, 0, iTimeout);

    if (iReadedBytes > 0)
    {
        int             iHeadSize = min(pBSD->iBufferSize - pBSD->iBufferIndex, iReadedBytes);

        if (iHeadSize > 0)
            memcpy(pBSD->pszBuffer + pBSD->iBufferIndex, pszBuffer, iHeadSize);

        pBSD->iBufferIndex += iHeadSize;

        if (pBSD->iBufferIndex == pBSD->iBufferSize)
            pBSD->iBufferIndex = 0;

        int             iBackSize = iReadedBytes - iHeadSize;

        if (iBackSize > 0)
            memcpy(pBSD->pszBuffer + pBSD->iBufferIndex, pszBuffer + iHeadSize, iBackSize);

        pBSD->iBufferIndex += iBackSize;

        pBSD->iBytesInBuffer += iReadedBytes;
    }

    free(pszBuffer);

    return (iReadedBytes);

}



int             BSckGetChar(BSOCK_HANDLE hBSock, int iTimeout)
{

    BuffSocketData *pBSD = (BuffSocketData *) hBSock;

    if ((pBSD->iBytesInBuffer == 0) &&
            (BSckReadData(pBSD, iTimeout) <= 0))
        return (BSOCK_EOF);

    int             iChar = (int) pBSD->pszBuffer[pBSD->iReadIndex];

    pBSD->iReadIndex = INext(pBSD->iReadIndex, pBSD->iBufferSize);

    --pBSD->iBytesInBuffer;

    return (iChar);

}



char           *BSckGetString(BSOCK_HANDLE hBSock, char *pszBuffer, int iBufferSize, int iTimeout)
{

    for (int ii = 0; ii < (iBufferSize - 1);)
    {
        int             iChar = BSckGetChar(hBSock, iTimeout);

        if (iChar == BSOCK_EOF)
            return (NULL);

        if (iChar == '\r')
        {
            iChar = BSckGetChar(hBSock, iTimeout);

            if (iChar == BSOCK_EOF)
                return (NULL);

            if (iChar == '\n')
                break;
            else
                pszBuffer[ii++] = '\r';
        }
        else
            pszBuffer[ii++] = (char) iChar;
    }

    pszBuffer[ii] = '\0';

    return (pszBuffer);

}



int             BSckSendString(BSOCK_HANDLE hBSock, char *pszBuffer, int iTimeout)
{

    BuffSocketData *pBSD = (BuffSocketData *) hBSock;
    char           *pszSendBuffer = (char *) malloc(strlen(pszBuffer) + 3);

    if (pszSendBuffer == NULL)
        return (-1);

    sprintf(pszSendBuffer, "%s\r\n", pszBuffer);

    int             iSendLength = strlen(pszSendBuffer);

    if (SvrSend(pBSD->SockFD, (unsigned char *) pszSendBuffer,
                    iSendLength, 0, iTimeout) != iSendLength)
    {
        free(pszSendBuffer);
        return (-1);
    }

    free(pszSendBuffer);

    return (iSendLength);

}



SOCKET          BSckGetAttachedSocket(BSOCK_HANDLE hBSock)
{

    BuffSocketData *pBSD = (BuffSocketData *) hBSock;

    return (pBSD->SockFD);

}
